<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use frontend\assets\AppAsset;
use common\widgets\Alert;
use yii\helpers\Url;
AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" type="image/png" href="<?php echo Yii::getAlias('@web');?>/assets/images/fav-ski.png"/>
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
 <div class="se-pre-con"></div>
<div id="preloader"></div> 
<?php $this->beginBody() ?>
  <?= $content ?>
<body>
<script>var base_url="<?php echo Url::to('/test/helpdeskv01/', true); ?>";</script>

<?php $this->endBody() ?>

</body>
</html>
<?php $this->endPage();
?>
<script>

<?php if (Yii::$app->session->hasFlash('success')): ?>
notify_('success','<?= Yii::$app->session->getFlash('success') ?>');

<?php endif; ?>
<?php if (Yii::$app->session->hasFlash('error')): ?>
notify_('danger','<?= Yii::$app->session->getFlash('error') ?>');
<?php endif; ?>



function notify_(type,msg){
$('html, body').animate({ scrollTop: 0 }, 1000, function () { 
});
$(".sm-container").prepend('<div style="opacity:49;" class="alert alert-'+type+' alert-dismissible fade in alert-c" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>'+msg+'</div>')
$(".alert-c").fadeOut(5000, function() { $(this).remove(); });
}

</script>



