<?php
$params = array_merge(
    require __DIR__ . '/../../common/config/params.php',
    require __DIR__ . '/../../common/config/params-local.php',
    require __DIR__ . '/params.php',
    require __DIR__ . '/module.php',
    require __DIR__ . '/params-local.php'

);

return [
    'id' => 'app-backend',
    'basePath' => dirname(__DIR__),
    'defaultRoute' => 'login',
    'controllerNamespace' => 'backend\controllers',
    'bootstrap' => ['log'],
    'modules' => [],
    'components' => [
        'request' => [
            'csrfParam' => '_csrf-backend',
        ],
        'user' => [
            'identityClass' => 'common\models\User',
            'enableAutoLogin' => true,
            'identityCookie' => ['name' => '_identity-backend', 'httpOnly' => true],
        ],
        'session' => [
            // this is the name of the session cookie used for login on the backend
            'name' => 'advanced-backend',
            
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
             'rules' => [
            '<alias:saveclient|saveuser|delete|saveticket|admin_mail|delete_c|savedepartment|delete_con|tracker|savemsg|savecategory|savecannedmsg|saveoption>' => 'site/<alias>', 
            '<alias:add-ticket>' => 'site/add_ticket',
            '<alias:ticket-list>' => 'site/ticket_list', 
            '<alias:add-client>' => 'site/add_client',
            '<alias:edit-client>' => 'site/edit_client',
            '<alias:client-list>' => 'site/client_list', 
            '<alias:user-list>' => 'site/user_list',
            '<alias:add-user>' => 'site/add_user', 
            '<alias:edit-user>' => 'site/edit_user', 
            '<alias:department-list>' => 'site/department_list',
            '<alias:add-department>' => 'site/add_department', 
            '<alias:edit-department>' => 'site/edit_department',
            '<alias:option-list>' => 'site/option_list',
            '<alias:edit-ticket>' => 'site/edit_ticket',  
            '<alias:view-ticket>' => 'site/view_ticket', 
            '<alias:report-list>' => 'site/report_list',         
            '<alias:push>' => 'site/push',         
             '<controller:\w+>/<action:\w+>'=>'<controller>/<action>',            
            '<alias:authenticate|dashboard|logout>' => 'login/<alias>', 
         

            ],
        ],
        
    ],
    'params' => $params,
];
